package examples.entity.bid.one_to_many;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import examples.entity.bid.one_to_many.interfaces.CompanyEmployeeOM;

@Stateless
public class CompanyEmployeeOMBidBean implements CompanyEmployeeOM {
	@PersistenceContext
	EntityManager em;

	public void doSomeStuff() {
		Company c = new Company();
		c.setName("M*Power Internet Services, Inc.");
		
		//Collection<Employee> employees = new ArrayList<Employee>();
		Employee e = new Employee();
		e.setName("Micah Silverman");
		e.setSex('M');
		e.setCompany(c);
		//employees.add(e);
		c.getEmployees().add(e);
		
		e = new Employee();
		e.setName("Tes Silverman");
		e.setSex('F');
		e.setCompany(c);
		//employees.add(e);
		c.getEmployees().add(e);
		
		//c.setEmployees(employees);
		em.persist(c);
		
		c = new Company();
		c.setName("Sun Microsystems");
		
		//employees = new ArrayList<Employee>();
		e = new Employee();
		e.setName("Rima Patel");
		e.setSex('F');
		e.setCompany(c);
		//employees.add(e);
		c.getEmployees().add(e);
		
		e = new Employee();
		e.setName("James Gosling");
		e.setSex('M');
		e.setCompany(c);
		//employees.add(e);
		c.getEmployees().add(e);
		
		//c.setEmployees(employees);
		em.persist(c);
		
		c = new Company();
		c.setName("Bob's Bait & Tackle");
		em.persist(c);
	}

	public List getCompanies() {
		Query q = em.createQuery("SELECT c FROM CompanyOMBid c");
		return q.getResultList();
	}

	public List getEmployees() {
		Query q = em.createQuery("SELECT e FROM EmployeeOMBid e");
		return q.getResultList();
	}
	
	public void deleteAll() {
		Query q = em.createQuery("DELETE FROM EmployeeOMBid");
		q.executeUpdate();
		q = em.createQuery("DELETE FROM CompanyOMBid");
		q.executeUpdate();
	}
}
